/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandom;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.data.SpawnData;

public class SpawnController {
    public static SpawnController instance;
    public final HashMap<String, List<SpawnData>> biomes = new HashMap();
    public final ArrayList<SpawnData> data = new ArrayList();
    private int lastUsedID = 0;
    public Random random = new Random();

    public SpawnController() {
        instance = this;
        instance.loadData();
    }

    private void fillBiomeData() {
        this.biomes.clear();
        for (SpawnData spawn : this.data) {
            for (String s : spawn.biomes) {
                List list = this.biomes.computeIfAbsent(s, k -> new ArrayList());
                list.add(spawn);
            }
        }
    }

    public NBTTagCompound getNBT() {
        NBTTagList list = new NBTTagList();
        for (SpawnData spawn : this.data) {
            NBTTagCompound nbtSummon = new NBTTagCompound();
            spawn.writeNBT(nbtSummon);
            list.func_74742_a((NBTBase)nbtSummon);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("lastID", this.lastUsedID);
        nbttagcompound.func_74782_a("NPCSpawnData", (NBTBase)list);
        return nbttagcompound;
    }

    public SpawnData getRandomSpawnData(String biome) {
        List<SpawnData> list = this.getSpawnList(biome);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (SpawnData)WeightedRandom.func_76271_a((Random)this.random, list);
    }

    public Map<String, Integer> getScroll() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (SpawnData spawn : this.data) {
            map.put(spawn.name, spawn.id);
        }
        return map;
    }

    public SpawnData getSpawnData(int id) {
        for (SpawnData spawn : this.data) {
            if (spawn.id != id) continue;
            return spawn;
        }
        return null;
    }

    public List<SpawnData> getSpawnList(String biome) {
        return this.biomes.get(biome);
    }

    public int getUnusedId() {
        return ++this.lastUsedID;
    }

    private void loadData() {
        CustomNpcs.debugData.start(null);
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        if (saveDir == null) {
            CustomNpcs.debugData.end(null);
            return;
        }
        try {
            File file = new File(saveDir, "spawns.dat");
            if (file.exists()) {
                this.loadDataFile(file);
            }
        }
        catch (Exception e) {
            try {
                File oldFile = new File(saveDir, "spawns.dat_old");
                if (oldFile.exists()) {
                    this.loadDataFile(oldFile);
                }
            }
            catch (Exception e1) {
                LogWriter.error(e1);
            }
        }
        CustomNpcs.debugData.end(null);
    }

    public void loadData(DataInputStream stream) throws IOException {
        NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInputStream)stream);
        this.lastUsedID = compound.func_74762_e("lastID");
        NBTTagList nbtList = compound.func_150295_c("NPCSpawnData", 10);
        this.data.clear();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbtSummon = nbtList.func_150305_b(i);
            SpawnData spawn = new SpawnData();
            spawn.readNBT(nbtSummon);
            if (spawn.name == null || spawn.name.isEmpty()) continue;
            this.data.add(spawn);
        }
        this.fillBiomeData();
    }

    private void loadDataFile(File file) throws IOException {
        DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]))));
        this.loadData(var1);
        var1.close();
    }

    public void removeSpawnData(int id) {
        ArrayList<SpawnData> newData = new ArrayList<SpawnData>();
        for (SpawnData spawn : this.data) {
            if (spawn.id == id || spawn.name == null || spawn.name.isEmpty()) continue;
            newData.add(spawn);
        }
        this.data.clear();
        this.data.addAll(newData);
        this.fillBiomeData();
        this.saveData();
    }

    public void saveData() {
        CustomNpcs.debugData.start(null);
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            File file = new File(saveDir, "spawns.dat_new");
            File file2 = new File(saveDir, "spawns.dat_old");
            File file3 = new File(saveDir, "spawns.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        CustomNpcs.debugData.end(null);
    }

    public void saveSpawnData(SpawnData spawn) {
        SpawnData spawnData;
        if (spawn.name == null || spawn.name.isEmpty()) {
            return;
        }
        if (spawn.id < 0) {
            spawn.id = this.getUnusedId();
        }
        if ((spawnData = this.getSpawnData(spawn.id)) == null) {
            this.data.add(spawn);
        } else {
            spawnData.readNBT(spawn.writeNBT(new NBTTagCompound()));
        }
        this.fillBiomeData();
        this.saveData();
    }
}

